%% Function to transform a set of  3D coordinates
% where transx is the transformed set of entered coordinates x using 3
% rotations and 3 translations for x, y and z in a vector called trans.
%
% Ali MacLeod
% University of Bath 2015
%
% transx are the transformed coordinates of x given 3 rotations and 3
% translations in the vector trans
%
function transx = TransFun_sc(x,trans)
%
if length(trans)~= 9
    error('the transformation variable should have 9 entries - 3 rotations, 3 translations and 3 scales')       
end
%
%%
% pad x ones
x=x';
[a,b]=size(x);
fill=zeros(a+1,b);
fill(a+1,:)=1;
fill(1:a,:)=x;
%disp('x')
%disp(fill)
% return x to original
% x=x';
% 
%% Scale First
% X scale
fill(:,1)=fill(:,1)*trans(7);
% Y scale
fill(:,2)=fill(:,2)*trans(8);
% Z scale
fill(:,3)=fill(:,3)*trans(9);
%
%% Basic Rotation about x,y and z
%
thetax=trans(1);
thetay=trans(2);
thetaz=trans(3);
transx=trans(4);
transy=trans(5);
transz=trans(6);
%
M=[ cos(thetay) * cos(thetaz) , ( cos(thetax) * sin(thetaz) ) + ( sin(thetax) * sin(thetay) * cos(thetaz) ) , ( sin(thetax) * sin(thetaz) ) - ( cos(thetax) * sin(thetay) * cos(thetaz)) , 0 ;
   -cos(thetay) * sin(thetaz) , ( cos(thetax) * cos(thetaz) ) - ( sin(thetax) * sin(thetay) * sin(thetaz) ) , ( sin(thetax) * cos(thetaz) ) + ( cos(thetax) * sin(thetay) * sin(thetaz)) , 0 ;
    sin(thetay) , -sin(thetax) * cos(thetay) , cos(thetax) * cos(thetay) , 0 
    0, 0 ,0 ,1 ];
%
%% Translation
T=[1,0,0,transx;
   0,1,0,transy;
   0,0,1,transz
   0,0,0,1];
%% Scale
%S=[1,0,0,0;
%    0,1,0,0;
%    0,0,1,0;
%    0,0,0,uniscale];
%
%TransM=M*T*S;
TransM=M*T;
%
%%
transxvec=TransM*fill;
%
% ensure the scale is consistant
%transxvec = transxvec / transxvec (4,4);
%transxvec = transxvec / transxvec (end,end);
%
%disp(transxvec)
transxvec=transxvec(1:a,:);
transx=transxvec';
%
end


